/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.power.factory.condition;

import io.github.apace100.origins.Origins;
import io.github.apace100.origins.power.factory.condition.ConditionFactory;
import io.github.apace100.origins.registry.ModRegistriesArchitectury;
import io.github.apace100.origins.util.SerializableData;
import io.github.apace100.origins.util.SerializableDataType;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.multiplayer.ClientAdvancementManager;
import net.minecraft.client.multiplayer.PlayerController;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public final class EntityConditionsClient {
    @OnlyIn(value=Dist.CLIENT)
    public static void register() {
        EntityConditionsClient.register(new ConditionFactory<LivingEntity>(Origins.identifier("using_effective_tool"), new SerializableData(), (data, entity) -> {
            PlayerController interactionMngr;
            if (entity instanceof ServerPlayerEntity) {
                PlayerInteractionManager interactionMngr2 = ((ServerPlayerEntity)entity).field_71134_c;
                if (interactionMngr2.field_73088_d) {
                    return ((PlayerEntity)entity).func_234569_d_(entity.field_70170_p.func_180495_p(interactionMngr2.field_180240_f));
                }
            } else if (entity instanceof ClientPlayerEntity && (interactionMngr = Minecraft.func_71410_x().field_71442_b).func_181040_m()) {
                return ((PlayerEntity)entity).func_234569_d_(entity.field_70170_p.func_180495_p(interactionMngr.field_178895_c));
            }
            return false;
        }));
        EntityConditionsClient.register(new ConditionFactory<LivingEntity>(Origins.identifier("gamemode"), new SerializableData().add("gamemode", SerializableDataType.STRING), (data, entity) -> {
            if (entity instanceof ServerPlayerEntity) {
                PlayerInteractionManager interactionMngr = ((ServerPlayerEntity)entity).field_71134_c;
                return interactionMngr.func_73081_b().func_77149_b().equals(data.getString("gamemode"));
            }
            if (entity instanceof ClientPlayerEntity) {
                return Minecraft.func_71410_x().field_71442_b.func_178889_l().func_77149_b().equals(data.getString("gamemode"));
            }
            return false;
        }));
        EntityConditionsClient.register(new ConditionFactory<LivingEntity>(Origins.identifier("advancement"), new SerializableData().add("advancement", SerializableDataType.IDENTIFIER), (data, entity) -> {
            ResourceLocation id = data.getId("advancement");
            if (entity instanceof ServerPlayerEntity) {
                Advancement advancement = entity.func_184102_h().func_191949_aK().func_192778_a(id);
                if (advancement != null) return ((ServerPlayerEntity)entity).func_192039_O().func_192747_a(advancement).func_192105_a();
                Origins.LOGGER.warn("Advancement \"" + id + "\" did not exist, but was referenced in an \"origins:advancement\" condition.");
                return false;
            } else {
                Map progressMap;
                ClientAdvancementManager advancementManager;
                Advancement advancement;
                if (!(entity instanceof ClientPlayerEntity) || (advancement = (advancementManager = Minecraft.func_71410_x().func_147114_u().func_191982_f()).func_194229_a().func_192084_a(id)) == null || !(progressMap = advancementManager.field_192803_d).containsKey(advancement)) return false;
                return ((AdvancementProgress)progressMap.get(advancement)).func_192105_a();
            }
        }));
    }

    private static void register(ConditionFactory<LivingEntity> conditionFactory) {
        ModRegistriesArchitectury.ENTITY_CONDITION.registerSupplied(conditionFactory.getSerializerId(), () -> conditionFactory);
    }
}

